//
// Copyright © 2025 Stream.io Inc. All rights reserved.
//

import Foundation
@testable import StreamChat

public extension CurrentChatUser {
    /// Creates a new `CurrentChatUser` object from the provided data.
    static func mock(
        id: String,
        name: String? = nil,
        imageURL: URL? = nil,
        isOnline: Bool = false,
        isInvisible: Bool = false,
        isBanned: Bool = false,
        userRole: UserRole = .user,
        createdAt: Date = .init(),
        updatedAt: Date = .init(),
        deactivatedAt: Date? = nil,
        lastActiveAt: Date? = nil,
        teams: Set<TeamId> = [],
        language: TranslationLanguage? = nil,
        blockedUserIds: Set<UserId> = [],
        extraData: [String: RawJSON] = [:],
        devices: [Device] = [],
        currentDevice: Device? = nil,
        mutedUsers: Set<ChatUser> = [],
        blockedUsers: Set<BlockedUserDetails> = [],
        flaggedUsers: Set<ChatUser> = [],
        flaggedMessageIDs: Set<MessageId> = [],
        unreadCount: UnreadCount = .noUnread,
        mutedChannels: Set<ChatChannel> = [],
        privacySettings: UserPrivacySettings = .init()
    ) -> CurrentChatUser {
        .init(
            id: id,
            name: name,
            imageURL: imageURL,
            isOnline: isOnline,
            isInvisible: isInvisible,
            isBanned: isBanned,
            userRole: userRole,
            createdAt: createdAt,
            updatedAt: updatedAt,
            deactivatedAt: deactivatedAt,
            lastActiveAt: lastActiveAt,
            teams: teams,
            language: language,
            extraData: extraData,
            devices: devices,
            currentDevice: currentDevice,
            blockedUserIds: blockedUserIds,
            mutedUsers: mutedUsers,
            flaggedUsers: flaggedUsers,
            flaggedMessageIDs: flaggedMessageIDs,
            unreadCount: unreadCount,
            mutedChannels: mutedChannels,
            privacySettings: privacySettings
        )
    }
}
